/*

   ARexx Web Server

   Version 2.0

*/



if ~show('L','rexxsupport.library') then addlib('rexxsupport.library',0,-30,0)


path="WWW:HTML"   /* No trailing "/"!! */
pull a

file=subword(a,2,1)

if right(file,1)="/" then file=file"index.html"

if index(upper(file),".CGI")~=0 then signal cgi

if exists(path||file)=0 then bad=1

if index(file,"//")~=0 then signal error

if index(file,":")~=0 then signal error

ext=upper(substr(file,lastpos(".",file),length(file)))

mime="text/html"

if ext=".HTML"|ext=".HTM"|ext=".HML" then mime="text/html"

if ext=".DOC"|ext=".TXT" then mime="text/plain"

if ext=".GUIDE" then mime="text/aguide"

if ext=".GIF" then mime="image/gif"

if ext=".JPG"|ext=".JPEG" then mime="image/jpeg"

if ext=".WAV"|ext=".AU"|ext=".8SVX" then mime="audio/*"

if ext=".MID"|ext=".MIDI" then mime="audio/x-midi"

if ext=".LHA"|ext=".LZH"|ext=".LZX" then mime="application/octet-stream"

if ext=".MOCHA" then mime="language/mocha"

if ext=".GSM"|ext=".GSD" then mime="audio/x-gsm"

if ext=".PS" then mime="application/postscript"

say "HTTP/1.0 200 OK"

say "Server: ARexxWebServer/2.0"

say "Date: "||date()||" "||time()

say "Author: Casey Halverson (cmdo@gte.net)"

say "Accept-ranges: bytes"

say "Content-length: "||subword(statef(path||file),2,1)

say "Content-type: "||mime

if bad=1 then signal bad

say ""

if mime~="text/html" then signal binary

call open(1,path||file,'r')

do until eof(1)=1

a=readln(1)

if index(a,"<! CGI=")~=0 then call cgi_html

say a

end

exit



cgi:

cgi=substr(file,lastpos("/",file)+1)

cgi=translate(cgi," ","?")

if exists(path||"/cgi-bin/"||subword(cgi,1,1))=0 then signal bad

say "HTTP/1.0 200 OK"

say "Server: ARexxWebServer/2.0"

say "Author: Casey Halverson (cmdo@gte.net)"

say "Date: "||date()||" "||time()

say ""

address command "rx "||path||"/cgi-bin/"||cgi||" "||file

exit



cgi_html:

parse var a null'<! CGI="'rexx'">'stuff

say null

address command "rx "||path||"/cgi-bin/"||rexx

say stuff

a=""

return



binary:

address command 'c:copy "'||path||file||'" CONSOLE:'

exit



bad:

say "HTTP/1.0 404 Not Found"

say "Content-Type: text/html"

say ""

say "<HTML><STRONG><H1>ERROR</H1></STRONG><H4><P><P>ARexxWebServer error 404:<BR> Page does not exist<BR>FILENAME: "||file||"</HTML>"

exit



error:

say "HTTP/1.0 400 Forbidden"

say "Content-Type: text/html"

say ""

say "<STRONG><H1>ERROR</H1></STRONG><H4><P><P>ARexxWebServer error 400:<BR> You may not place : or double //'s in a URL<BR>FILENAME: "||file||"</HTML>"

exit

